
from gurobipy import *

# Create a new model
m = Model("Snack_Mix_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="snack_mix_A")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="snack_mix_B")

# Set objective function
m.setObjective(1.00*x1 + 1.20*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x1 + 10*x2 >= 90, "cashew_constraint")
m.addConstr(30*x1 + 45*x2 >= 80, "peanut_constraint")
m.addConstr(x1 <= 12, "snack_mix_A_limit")
m.addConstr(x1 >= 0, "non_negativity_x1")
m.addConstr(x2 >= 0, "non_negativity_x2")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Snack Mix A: {x1.x}")
    print(f"Snack Mix B: {x2.x}")
    print(f"Total Cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
