
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="snack_mix_A")
    x2 = model.addVar(lb=0, name="snack_mix_B")

    # Objective function: minimize 1.00*x1 + 1.20*x2
    model.setObjective(1.00*x1 + 1.20*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20*x1 + 10*x2 >= 90, name="cashew_constraint")
    model.addConstr(30*x1 + 45*x2 >= 80, name="peanut_constraint")
    model.addConstr(x1 <= 12, name="snack_mix_A_limit")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Snack mix A: {x1.varValue}")
        print(f"Snack mix B: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
