
import gurobipy as gp

# Create a new model
m = gp.Model("smoothie_optimization")

# Create variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peanut_butter_smoothies") # Number of peanut butter smoothies
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="almond_butter_smoothies") # Number of almond butter smoothies


# Set objective function
m.setObjective(5*x1 + 4*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 <= 50, "almond_milk_constraint")
m.addConstr(x1 + 1.5*x2 <= 40, "protein_powder_constraint")
m.addConstr(x1 >= 0, "peanut_butter_nonnegativity")
m.addConstr(x2 >= 0, "almond_butter_nonnegativity")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of peanut butter smoothies: {x1.x}")
    print(f"Number of almond butter smoothies: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

