
from gurobipy import *

# Create a new model
m = Model("Smoothie_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peanut_butter_smoothies")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="almond_butter_smoothies")

# Set the objective function
m.setObjective(5*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 <= 50, "almond_milk_constraint")
m.addConstr(x1 + 1.5*x2 <= 40, "protein_powder_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of peanut butter smoothies: {x1.x}")
    print(f"Number of almond butter smoothies: {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
