
import gurobipy as gp

# Create a new model
model = gp.Model("smoothie_problem")

# Define variables
x1 = model.addVar(name="peanut_butter_smoothies", lb=0)
x2 = model.addVar(name="almond_butter_smoothies", lb=0)

# Objective function: maximize profit
model.setObjective(5*x1 + 4*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3*x1 + 2*x2 <= 50, name="almond_milk_constraint")
model.addConstr(x1 + 1.5*x2 <= 40, name="protein_powder_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Maximum profit: ${5*x1.varValue + 4*x2.varValue:.2f}")
else:
    print("The model is infeasible.")
