
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Wage Bill")

# Create variables
international_employees = model.addVar(vtype=GRB.CONTINUOUS, name="international_employees")  # x1
local_employees = model.addVar(vtype=GRB.CONTINUOUS, name="local_employees")  # x2


# Set objective function
model.setObjective(500 * international_employees + 1200 * local_employees, GRB.MINIMIZE)

# Add constraints
model.addConstr(international_employees + local_employees >= 50, "Total employees")
model.addConstr(local_employees >= 12, "Minimum local employees")
model.addConstr(local_employees >= (1/3) * international_employees, "Local vs International ratio")
model.addConstr(500 * international_employees + 1200 * local_employees <= 40000, "Wage bill limit")
model.addConstr(international_employees >= 0, "Non-negative international")
model.addConstr(local_employees >= 0, "Non-negative local")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Minimum wage bill: ${model.objVal}")
    print(f"Number of international employees: {international_employees.x}")
    print(f"Number of local employees: {local_employees.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

