
from gurobipy import *

# Create a new model
m = Model("Wage_Bill_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="international_employees")
x2 = m.addVar(vtype=GRB.INTEGER, name="local_employees")

# Set the objective function
m.setObjective(500*x1 + 1200*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 50, "total_employees")
m.addConstr(x2 >= 12, "minimum_local_employees")
m.addConstr(x2 >= (1/3)*x1, "local_to_international_ratio")
m.addConstr(500*x1 + 1200*x2 <= 40000, "wage_bill_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"International Employees: {x1.x}")
    print(f"Local Employees: {x2.x}")
    print(f"Total Wage Bill: ${500*x1.x + 1200*x2.x}")
else:
    print("No optimal solution found")
