
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="international_employees")
    x2 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="local_employees")

    # Objective function: Minimize 500*x1 + 1200*x2
    model.setObjective(500*x1 + 1200*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 + x2 >= 50, name="total_employees")
    model.addConstr(x2 >= 12, name="local_employees_min")
    model.addConstr(x2 >= (1/3)*x1, name="local_to_international_ratio")
    model.addConstr(500*x1 + 1200*x2 <= 40000, name="wage_bill")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"International Employees: {x1.varValue}")
        print(f"Local Employees: {x2.varValue}")
        print(f"Minimum Wage Bill: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
