
import gurobipy as gp

# Create a new model
m = gp.Model("perfume_mix")

# Create variables
french_perfume = m.addVar(lb=0, name="french_perfume")
spanish_perfume = m.addVar(lb=0, name="spanish_perfume")

# Set objective function
m.setObjective(50 * french_perfume + 45 * spanish_perfume, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * french_perfume + 30 * spanish_perfume >= 150, "flower_scent")
m.addConstr(50 * french_perfume + 40 * spanish_perfume >= 60, "fruit_scent")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Buy {french_perfume.x} bottles of French perfume and {spanish_perfume.x} bottles of Spanish perfume")
    print(f"Minimum cost: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

