
from gurobipy import *

# Create a model
m = Model("Perfume_Mixing_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="French_Perfume", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Spanish_Perfume", lb=0)

# Set objective function
m.setObjective(50*x1 + 45*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x1 + 30*x2 >= 150, "Flower_Scent_Constraint")
m.addConstr(50*x1 + 40*x2 >= 60, "Fruit_Scent_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Buy {x1.x} bottles of French perfume and {x2.x} bottles of Spanish perfume.")
    print(f"Total cost: ${50*x1.x + 45*x2.x}")
else:
    print("No optimal solution found")
