
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='French_perfume', lb=0, vtype=gurobi.GRB.CONTINUOUS)
x2 = model.addVar(name='Spanish_perfume', lb=0, vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(50*x1 + 45*x2, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(20*x1 + 30*x2 >= 150, name='flower_scent_constraint')
model.addConstr(50*x1 + 40*x2 >= 60, name='fruit_scent_constraint')

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Optimal solution found.')
    print(f'Number of bottles of French perfume: {x1.varValue}')
    print(f'Number of bottles of Spanish perfume: {x2.varValue}')
    print(f'Total cost: {model.objVal}')
else:
    print('No optimal solution found.')
