
import gurobipy as gp

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
carrots = m.addVar(lb=0, name="carrots")  # Acres of carrots
peas = m.addVar(lb=0, name="peas")  # Acres of green peas


# Set objective function: Maximize profit
m.setObjective(250 * carrots + 340 * peas, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(carrots + peas <= 100, "land_constraint")  # Total land constraint
m.addConstr(0.7 * carrots + 0.4 * peas <= 135, "watering_constraint")  # Watering constraint
m.addConstr(1.2 * carrots + 1.5 * peas <= 110, "spraying_constraint")  # Spraying constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {carrots.x:.2f} acres of carrots")
    print(f"Plant {peas.x:.2f} acres of green peas")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

