
from gurobipy import *

# Create a new model
m = Model("Farm_Optimization")

# Define variables
x1 = m.addVar(name='acres_of_carrots', lb=0)
x2 = m.addVar(name='acres_of_green_peas', lb=0)

# Set the objective function
m.setObjective(250*x1 + 340*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.7*x1 + 0.4*x2 <= 135, name='watering_constraint')
m.addConstr(1.2*x1 + 1.5*x2 <= 110, name='spraying_constraint')
m.addConstr(x1 + x2 <= 100, name='land_constraint')

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
