
import gurobipy as gp

# Create a new model
model = gp.Model("Vegetable_Farming")

# Define the variables
x1 = model.addVar(name="carrots", lb=0, ub=100, obj=250)  # Acres of carrots
x2 = model.addVar(name="green_peas", lb=0, ub=100, obj=340)  # Acres of green peas

# Define the constraints
model.addConstr(0.7 * x1 + 0.4 * x2 <= 135, name="watering_days")
model.addConstr(1.2 * x1 + 1.5 * x2 <= 110, name="spraying_days")
model.addConstr(x1 + x2 <= 100, name="farmland")

# Set the model to maximize
model.ModelSense = -1

# Solve the model
model.optimize()

# Print the results
if model.Status == gp.OPTIMAL:
    print(f"Optimal acres of carrots: {x1.varValue}")
    print(f"Optimal acres of green peas: {x2.varValue}")
    print(f"Maximal profit: {model.objVal}")
else:
    print("The model is infeasible.")
