
import gurobipy as gp

# Create a new model
m = gp.Model("desk_production")

# Create variables
regular_desks = m.addVar(vtype=gp.GRB.CONTINUOUS, name="regular_desks")
standing_desks = m.addVar(vtype=gp.GRB.CONTINUOUS, name="standing_desks")


# Set objective function
m.setObjective(200 * regular_desks + 300 * standing_desks, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * regular_desks + 15 * standing_desks <= 4000, "wood_constraint")
m.addConstr(10 * regular_desks + 20 * standing_desks <= 1500, "packaging_constraint")
m.addConstr(regular_desks >= 0, "regular_desks_nonnegative")  # Ensure non-negative production
m.addConstr(standing_desks >= 0, "standing_desks_nonnegative") # Ensure non-negative production

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of regular desks to produce: {regular_desks.x}")
    print(f"Number of standing desks to produce: {standing_desks.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

