
from gurobipy import *

# Create a new model
m = Model("Desk_Production")

# Define variables
x1 = m.addVar(lb=0, name="regular_desks")
x2 = m.addVar(lb=0, name="standing_desks")

# Set the objective function
m.setObjective(200*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 <= 4000, "wood_constraint")
m.addConstr(10*x1 + 20*x2 <= 1500, "packaging_time_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of regular desks: {x1.x}")
    print(f"Number of standing desks: {x2.x}")
    print(f"Maximum profit: ${200*x1.x + 300*x2.x}")
else:
    print("No optimal solution found")
