
import gurobi

def solve_desk_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="regular_desks", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="standing_desks", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(200 * x1 + 300 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20 * x1 + 15 * x2 <= 4000, name="wood_constraint")
    model.addConstr(10 * x1 + 20 * x2 <= 1500, name="packaging_time_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_desk_production_problem()
