
import gurobipy as gp

# Create a new model
model = gp.Model("VitaminOptimization")

# Create decision variables
special_formula = model.addVar(vtype=gp.GRB.CONTINUOUS, name="special_formula")
one_daily = model.addVar(vtype=gp.GRB.CONTINUOUS, name="one_daily")


# Set objective function
model.setObjective(0.50 * special_formula + 0.20 * one_daily, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * special_formula + 3 * one_daily >= 25, "Vitamin_A_Requirement")
model.addConstr(5 * special_formula + 7 * one_daily >= 40, "Vitamin_B_Requirement")
model.addConstr(special_formula >=0)
model.addConstr(one_daily >= 0)


# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Special Formula capsules: {special_formula.x:.2f}")
    print(f"One Daily capsules: {one_daily.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

