
from gurobipy import *

# Create a new model
m = Model("Vitamin_Supplement")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Special Formula capsules")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="One Daily capsules")

# Set the objective function
m.setObjective(0.50*x1 + 0.20*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 3*x2 >= 25, "Vitamin A requirement")
m.addConstr(5*x1 + 7*x2 >= 40, "Vitamin B requirement")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Special Formula capsules: {x1.x}")
    print(f"One Daily capsules: {x2.x}")
    print(f"Total cost: ${0.50*x1.x + 0.20*x2.x:.2f}")
else:
    print("No optimal solution found")
