
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Special Formula capsules", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="One Daily capsules", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(0.50 * x1 + 0.20 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(4 * x1 + 3 * x2 >= 25, name="Vitamin A constraint")
    model.addConstr(5 * x1 + 7 * x2 >= 40, name="Vitamin B constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_optimization_problem()
