
from gurobipy import *

# Create a new model
m = Model("Hot_Dog_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="regular_hot_dogs")
x2 = m.addVar(lb=0, name="premium_hot_dogs")

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 80, "max_regular_hot_dogs")
m.addConstr(x2 <= 70, "max_premium_hot_dogs")
m.addConstr(x1 + x2 <= 120, "total_hot_dogs_supply")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of regular hot dogs: {x1.x}")
    print(f"Number of premium hot dogs: {x2.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
