
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="x1")
x2 = model.addVar(lb=0, name="x2")

# Set the objective function
model.setObjective(3*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 80, name="demand_regular")
model.addConstr(x2 <= 70, name="demand_premium")
model.addConstr(x1 + x2 <= 120, name="supply_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Regular hot dogs: {x1.varValue}")
    print(f"Premium hot dogs: {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found.")
