
from gurobipy import Model, GRB

# Create a new model
model = Model("Ticket Optimization")

# Create variables
all_inclusive = model.addVar(vtype=GRB.INTEGER, name="all_inclusive")
regular = model.addVar(vtype=GRB.INTEGER, name="regular")

# Set objective function
model.setObjective(50 * all_inclusive + 20 * regular, GRB.MAXIMIZE)

# Add constraints
model.addConstr(all_inclusive + regular <= 500, "Total tickets")
model.addConstr(all_inclusive >= 100, "Min all-inclusive")
model.addConstr(regular >= 3 * all_inclusive, "Regular vs all-inclusive")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"All-inclusive tickets: {all_inclusive.x}")
    print(f"Regular tickets: {regular.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

