
from gurobipy import *

# Create a new model
m = Model("Amusement_Park_Ticket_Sales")

# Define variables
x1 = m.addVar(name='all_inclusive_tickets', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='regular_tickets', vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(50*x1 + 20*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 500, name='total_tickets')
m.addConstr(x1 >= 100, name='all_inclusive_minimum')
m.addConstr(x2 >= 3*x1, name='regular_vs_all_inclusive')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"All-inclusive tickets: {x1.x}")
    print(f"Regular tickets: {x2.x}")
    print(f"Maximum profit: ${50*x1.x + 20*x2.x}")
else:
    print("No optimal solution found")
