
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="all_inclusive_tickets")
    x2 = model.addVar(lb=0, name="regular_tickets")

    # Objective function: maximize 50*x1 + 20*x2
    model.setObjective(50*x1 + 20*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 500, name="capacity_constraint")
    model.addConstr(x1 >= 100, name="all_inclusive_min")
    model.addConstr(x2 >= 3*x1, name="regular_vs_all_inclusive")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"All-inclusive tickets: {x1.varValue}")
        print(f"Regular tickets: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_problem()
