
import gurobipy as gp

# Create a new model
model = gp.Model("T-Shirt Production")

# Create variables
blue_tshirts = model.addVar(vtype=gp.GRB.CONTINUOUS, name="blue_tshirts")  # Number of blue t-shirts
dark_blue_tshirts = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dark_blue_tshirts")  # Number of dark blue t-shirts


# Set objective function
model.setObjective(10 * blue_tshirts + 15 * dark_blue_tshirts, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * blue_tshirts + 5 * dark_blue_tshirts <= 1000, "dye_constraint")
model.addConstr(5 * blue_tshirts + 4 * dark_blue_tshirts <= 1200, "water_constraint")
model.addConstr(30 * blue_tshirts + 25 * dark_blue_tshirts <= 8000, "worker_minutes_constraint")
model.addConstr(blue_tshirts >=0)
model.addConstr(dark_blue_tshirts >=0)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Profit = ${model.objVal}")
    print(f"Number of blue t-shirts: {blue_tshirts.x}")
    print(f"Number of dark blue t-shirts: {dark_blue_tshirts.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

