
from gurobipy import *

# Create a new model
m = Model("Clothing_Company")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="blue_tshirts")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="dark_blue_tshirts")

# Set the objective function
m.setObjective(10*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 1000, "dye_constraint")
m.addConstr(5*x1 + 4*x2 <= 1200, "water_constraint")
m.addConstr(30*x1 + 25*x2 <= 8000, "worker_minutes_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Blue t-shirts: {x1.x}")
    print(f"Dark blue t-shirts: {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
