
import gurobipy as gp

# Create a new model
model = gp.Model("T-Shirt_Production")

# Define variables
x1 = model.addVar(name="blue_tshirts", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="dark_blue_tshirts", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(10*x1 + 15*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3*x1 + 5*x2 <= 1000, name="dye_constraint")
model.addConstr(5*x1 + 4*x2 <= 1200, name="water_constraint")
model.addConstr(30*x1 + 25*x2 <= 8000, name="worker_minutes_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Maximum profit: ${10*x1.varValue + 15*x2.varValue:.2f}")
else:
    print("The model is infeasible.")
