
import gurobipy as gp

# Create a new model
m = gp.Model("auto_manufacturing")

# Create variables
doors = m.addVar(vtype=gp.GRB.INTEGER, name="doors")
bumpers = m.addVar(vtype=gp.GRB.INTEGER, name="bumpers")

# Set objective function
m.setObjective(200 * doors + 150 * bumpers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * doors + 10 * bumpers <= 3000, "machine_time")
m.addConstr(doors <= 100, "door_limit")
m.addConstr(bumpers <= 200, "bumper_limit")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of doors to produce: {doors.x}")
    print(f"Number of bumpers to produce: {bumpers.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

