
from gurobipy import *

# Create a model
m = Model("Auto_Manufacturing")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="doors")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bumpers")

# Set the objective function
m.setObjective(200*x1 + 150*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 10*x2 <= 3000, "machine_time")
m.addConstr(x1 <= 100, "door_limit")
m.addConstr(x2 <= 200, "bumper_limit")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Doors: {x1.x}")
    print(f"Bumpers: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
