
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, ub=100, name="doors")
    x2 = model.addVar(lb=0, ub=200, name="bumpers")

    # Define the objective function
    model.setObjective(200 * x1 + 150 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(20 * x1 + 10 * x2 <= 3000, name="machine_time")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Number of doors: {x1.varValue}")
        print(f"Number of bumpers: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
