
import gurobipy as gp

# Create a new model
model = gp.Model("Action Figure Shelves")

# Create variables
small_shelves = model.addVar(vtype=gp.GRB.INTEGER, name="small_shelves")
large_shelves = model.addVar(vtype=gp.GRB.INTEGER, name="large_shelves")

# Set objective function
model.setObjective(20 * small_shelves + 30 * large_shelves, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * small_shelves + 6 * large_shelves <= 100, "space_constraint")
model.addConstr(50 * small_shelves + 80 * large_shelves <= 1250, "budget_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small shelves: {small_shelves.x}")
    print(f"Number of large shelves: {large_shelves.x}")
    print(f"Total number of action figures: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

