
from gurobipy import *

# Create a new model
m = Model("Shelf_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="small_shelves")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="large_shelves")

# Set the objective function
m.setObjective(20*x1 + 30*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 6*x2 <= 100, "space_constraint")
m.addConstr(50*x1 + 80*x2 <= 1250, "budget_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Small shelves: {x1.x}")
    print(f"Large shelves: {x2.x}")
    print(f"Total action figures stored: {20*x1.x + 30*x2.x}")
else:
    print("No optimal solution found")
