
import gurobipy as gp

# Create a new model
model = gp.Model("shelf_optimization")

# Define variables
x1 = model.addVar(name="small_shelves", lb=0, vtype=gp.GRB.INTEGER)  # Number of small shelves
x2 = model.addVar(name="large_shelves", lb=0, vtype=gp.GRB.INTEGER)  # Number of large shelves

# Objective function: Maximize the number of action figures
model.setObjective(20*x1 + 30*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3*x1 + 6*x2 <= 100, name="space_constraint")  # Space constraint
model.addConstr(50*x1 + 80*x2 <= 1250, name="budget_constraint")  # Budget constraint

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum number of action figures: {20*x1.x + 30*x2.x}")
else:
    print("No optimal solution found")
