
import gurobipy as gp

# Create a new model
m = gp.Model("telecom_optimization")

# Create variables
internet = m.addVar(vtype=gp.GRB.CONTINUOUS, name="internet")  # Internet installations
tv = m.addVar(vtype=gp.GRB.CONTINUOUS, name="tv")  # TV installations


# Set objective function
m.setObjective(100 * internet + 120 * tv, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(60 * internet + 50 * tv <= 7000, "wiring_time")
m.addConstr(10 * internet + 20 * tv <= 4000, "box_installation_time")
m.addConstr(internet >= 0)
m.addConstr(tv >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Internet installations: {internet.x}")
    print(f"TV installations: {tv.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

