
from gurobipy import *

# Create a model
m = Model("Telecom_Optimization")

# Define variables
x1 = m.addVar(name="Internet_Services", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="TV_Services", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(100*x1 + 120*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(60*x1 + 50*x2 <= 7000, name="Wiring_Time_Constraint")
m.addConstr(10*x1 + 20*x2 <= 4000, name="Box_Installation_Time_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Internet Services: {x1.x}")
    print(f"Number of TV Services: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
