
import gurobipy as gp

# Create a new model
model = gp.Model("Telecommunications_Service_Installation")

# Define the variables
x1 = model.addVar(name="internet_service", lb=0, vtype=gp.GRB.INTEGER)  # Number of internet services
x2 = model.addVar(name="tv_service", lb=0, vtype=gp.GRB.INTEGER)  # Number of TV services

# Define the objective function
model.setObjective(100*x1 + 120*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(60*x1 + 50*x2 <= 7000, name="wiring_time_constraint")
model.addConstr(10*x1 + 20*x2 <= 4000, name="box_installation_time_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of internet service installations: {x1.varValue}")
    print(f"Optimal number of TV service installations: {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
