
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("makeup_optimization")

# Create variables
perfume = m.addVar(lb=0, vtype=GRB.INTEGER, name="perfume")
mascara = m.addVar(lb=0, vtype=GRB.INTEGER, name="mascara")

# Set objective function
m.setObjective(20 * perfume + 15 * mascara, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50 * perfume + 40 * mascara <= 20000, "budget")
m.addConstr(perfume >= 20, "perfume_min")
m.addConstr(perfume <= 40, "perfume_max")
m.addConstr(mascara <= (1/3) * perfume, "mascara_limit")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of perfume bottles: {perfume.x}")
    print(f"Number of mascara bottles: {mascara.x}")

