
from gurobipy import *

# Create a new model
m = Model("Makeup_Store_Profit")

# Define the variables
x1 = m.addVar(vtype=GRB.INTEGER, name="perfume_bottles")
x2 = m.addVar(vtype=GRB.INTEGER, name="mascara_bottles")

# Set the objective function
m.setObjective(20*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x1 + 40*x2 <= 20000, "budget_constraint")
m.addConstr(x1 >= 20, "min_perfume_sales")
m.addConstr(x1 <= 40, "max_perfume_sales")
m.addConstr(x2 <= (1/3)*x1, "mascara_to_perfume_ratio")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of perfume bottles: {x1.x}")
    print(f"Number of mascara bottles: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
