
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, ub=40, name="perfume")
    x2 = model.addVar(lb=0, name="mascara")

    # Set objective function
    model.setObjective(20*x1 + 15*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(50*x1 + 40*x2 <= 20000, name="budget_constraint")
    model.addConstr(x1 >= 20, name="min_perfume_constraint")
    model.addConstr(x1 <= 40, name="max_perfume_constraint")
    model.addConstr(x2 <= (1/3)*x1, name="mascara_vs_perfume_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of bottles of perfume to buy and sell: {x1.varValue}")
        print(f"Number of bottles of mascara to buy and sell: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
