
import gurobipy as gp

# Create a new model
m = gp.Model("toothpaste_investment")

# Create variables
x1 = m.addVar(name="investment_A") # Investment in company A
x2 = m.addVar(name="investment_B") # Investment in company B


# Set objective function
m.setObjective(0.12 * x1 + 0.14 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 5000, "total_investment")
m.addConstr(x1 >= 0.4 * (x1 + x2), "min_investment_A")
m.addConstr(x2 >= 1000, "min_investment_B")
m.addConstr(x1 >=0, "non_negativity_A")
m.addConstr(x2 >=0, "non_negativity_B")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Invest ${x1.x:.2f} in company A")
    print(f"Invest ${x2.x:.2f} in company B")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

