
from gurobipy import *

# Create a new model
m = Model("Toothpaste_Investment")

# Add variables
x1 = m.addVar(lb=0, name="amount_invested_in_A")
x2 = m.addVar(lb=0, name="amount_invested_in_B")

# Set the objective function
m.setObjective(0.12*x1 + 0.14*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 5000, name="total_investment")
m.addConstr(0.6*x1 >= 0.4*x2, name="percentage_in_A")
m.addConstr(x2 >= 1000, name="minimum_in_B")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount invested in A: {x1.x}")
    print(f"Amount invested in B: {x2.x}")
    print(f"Total profit: {0.12*x1.x + 0.14*x2.x}")
else:
    print("No optimal solution found")
