
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # Investment in toothpaste company A
    x2 = model.addVar(name="x2", lb=0)  # Investment in toothpaste company B

    # Objective function: maximize 0.12*x1 + 0.14*x2
    model.setObjective(0.12 * x1 + 0.14 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 5000)  # Total investment not exceeding $5000
    model.addConstr(0.6 * x1 - 0.4 * x2 >= 0)  # At least 40% in toothpaste company A
    model.addConstr(x2 >= 1000)  # At least $1000 in toothpaste company B

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in toothpaste company A: ${x1.varValue:.2f}")
        print(f"Optimal investment in toothpaste company B: ${x2.varValue:.2f}")
        print(f"Maximal profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
