
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
gummy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="gummy") # Number of gummy vitamins
powder = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="powder") # Number of powder vitamins

# Set objective function: Minimize cost
m.setObjective(1*gummy + 3*powder, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*gummy + 6*powder >= 14, "vitamin_B_req") # Vitamin B requirement
m.addConstr(7*gummy + 2*powder >= 24, "vitamin_D_req") # Vitamin D requirement


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal}")
    print(f"Number of gummy vitamins: {gummy.x}")
    print(f"Number of powder vitamins: {powder.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

