
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="gummy_vitamins")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="powder_vitamins")

# Set the objective function
m.setObjective(1*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 6*x2 >= 14, "vitamin_b")
m.addConstr(7*x1 + 2*x2 >= 24, "vitamin_d")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of gummy vitamins: {x1.x}")
    print(f"Number of powder vitamins: {x2.x}")
    print(f"Total cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
