
import gurobi

def solve_vitamin_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="gummy_vitamins")
    x2 = model.addVar(lb=0, name="powder_vitamins")

    # Define the objective function
    model.setObjective(1*x1 + 3*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2*x1 + 6*x2 >= 14, name="vitamin_B_requirement")
    model.addConstr(7*x1 + 2*x2 >= 24, name="vitamin_D_requirement")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of gummy vitamins: {x1.varValue}")
        print(f"Number of powder vitamins: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_vitamin_problem()
