
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Ice Cream Production")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="maple_pecan") # batches of maple pecan
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="mint_chocolate") # batches of mint chocolate

# Set objective function
m.setObjective(400*x1 + 250*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x1 + 30*x2 <= 8000, "mixing_constraint")
m.addConstr(80*x1 + 70*x2 <= 10000, "freezing_constraint")
m.addConstr(x1 >= 0, "maple_pecan_nonneg")
m.addConstr(x2 >= 0, "mint_chocolate_nonneg")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Maple Pecan batches: {x1.x:.2f}")
    print(f"Mint Chocolate batches: {x2.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

