
from gurobipy import *

# Create a model
m = Model("IceCreamProduction")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="maple_pecan_batches", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="mint_chocolate_batches", lb=0)

# Set the objective function
m.setObjective(400*x1 + 250*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x1 + 30*x2 <= 8000, "mixing_machine_time")
m.addConstr(80*x1 + 70*x2 <= 10000, "freezing_machine_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
