
import gurobipy as gp

# Create a new model
model = gp.Model("IceCreamProduction")

# Define variables
x1 = model.addVar(name="maple_pecan", lb=0, vtype=gp.GRB.CONTINUOUS)  # batches of maple pecan ice cream
x2 = model.addVar(name="mint_chocolate", lb=0, vtype=gp.GRB.CONTINUOUS)  # batches of mint chocolate ice cream

# Objective function: maximize profit
model.setObjective(400 * x1 + 250 * x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(50 * x1 + 30 * x2 <= 8000, name="mixing_machine_constraint")
model.addConstr(80 * x1 + 70 * x2 <= 10000, name="freezing_machine_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal batches of maple pecan ice cream: {x1.varValue}")
    print(f"Optimal batches of mint chocolate ice cream: {x2.varValue}")
    print(f"Maximal profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible or unbounded.")
