
import gurobipy as gp

# Create a new model
m = gp.Model("electronics_production")

# Create variables
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="entry_level") # number of entry-level devices sold
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="premium") # number of premium devices sold


# Set objective function
m.setObjective(300*x1 + 200*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 20, "entry_level_demand")
m.addConstr(x2 <= 15, "premium_demand")
m.addConstr(x1 + x2 <= 30, "total_demand")
m.addConstr(x1 >= 0, "entry_level_nonnegative")  # Ensure non-negative values
m.addConstr(x2 >= 0, "premium_nonnegative")  # Ensure non-negative values


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of entry-level devices to sell: {x1.x}")
    print(f"Number of premium devices to sell: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

